function [res] = MeGini_test_Serhiy(income, fraction)
    
    n = size(income,1);
    [income, I] = sort(income); 
    % order 'income' by ascending, where 'I' give the position number of elements, return 'income' = [I_u, I_s, I_uu, I_us, I_su, I_ss]'
    % return 'I' = [6, 5, 4, 3, 2, 1]', which corresponding to the position
    % number of each element

    fx = fraction(I); 
    % reorder 'fraction' according to position number [6th of 'fraction', 5th, 4th, 3th, 2th, 1th]'
    % 'fraction' must be this: [piss; pisu; pius; piuu; pis; piu]
    % fx = [piu, pis, piuu, pius, pisu, piss]'
    % change original fraction row'th order, 6th row now as 1st row

    income = income.*fx; % HH income times corresponding fraction
    % income = [I_u*piu, I_s*pis, I_uu*piuu, I_us*pius, I_su*pisu, I_ss*piss]'
    res = income(1)*fx(1); % = I_u*piu*piu
    for i = 2 : n
       income(i) = income(i)+income(i-1); % when i = 2, 2nd row of income + 1st row of income gen new income
       res = res+(income(i)+income(i-1))*fx(i);
       fx(i)=fx(i)+fx(i-1);
    end
    res = 1-res/income(n);
end

